#include "General.h"
#include "SnipersPointsCreditsMod.h"
#include "PhysicalGameObj.h"
#include "weaponmgr.h"
#include "ArmorWarheadManager.h"
#include "VehicleGameObjDef.h"
#include "gmlog.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

SnipersPointsCreditsMod::SnipersPointsCreditsMod()
{
	RegisterEvent(EVENT_STOCK_DAMAGE_HOOK,this);
	RegisterEvent(EVENT_TT_DAMAGE_HOOK,this);
}

SnipersPointsCreditsMod::~SnipersPointsCreditsMod()
{
	UnregisterEvent(EVENT_STOCK_DAMAGE_HOOK,this);
	UnregisterEvent(EVENT_TT_DAMAGE_HOOK,this);
}

bool SnipersPointsCreditsMod::OnTtDamage(PhysicalGameObj* damager, PhysicalGameObj* target, const AmmoDefinitionClass* ammo, const char* bone)
{
	if ( (ammo->Warhead == 3) && target->As_VehicleGameObj() )
	{
		//		if ( Commands->Is_A_Star(damager) )
		//		{
		const WeaponDefinitionClass *CurrentWeaponDef = Get_Current_Weapon_Definition(damager);
		if ( CurrentWeaponDef->CanSnipe )
		{
			float DamageMultiplier = ArmorWarheadManager::Get_Damage_Multiplier(target->Get_Defense_Object()->Get_Shield_Type(), (int)ammo->Warhead);
			float DamageCalculated = DamageMultiplier * (float)ammo->Damage;

//			Console_Output("TT: damageCalculated = %f, DamageMultiplier = %f, ammoDamage = %f\n", 
//				DamageCalculated, DamageMultiplier, (float)ammo->Damage); // DEBUG CRAP

			if (DamageCalculated < 30.f)
			{
				int PlayerID = Get_Player_ID(damager);

				float Credits = Get_Money(PlayerID);
				float Points = Get_Score(PlayerID);
				int Team = Get_Team(PlayerID);
				float TeamScore = Get_Team_Score(Team);

				Commands->Apply_Damage(target, ammo->Damage, "Shrapnel", damager);

				Set_Money(PlayerID, Credits+1.0f);
				Set_Score(PlayerID, Points+1.0f);
				Set_Team_Score(Team, TeamScore+1.0f);

				return false;
			}
		}
		//		}
	}
	return true;
}
bool SnipersPointsCreditsMod::OnStockDamage(PhysicalGameObj* damager, PhysicalGameObj* target, float damage, uint warheadId)
{
	if ( (warheadId == 3) && target->As_VehicleGameObj() )
	{
//		if ( Commands->Is_A_Star(damager) )
//		{
			const WeaponDefinitionClass *CurrentWeaponDef = Get_Current_Weapon_Definition(damager);
			if ( CurrentWeaponDef->CanSnipe )
			{
				float DamageMultiplier = ArmorWarheadManager::Get_Damage_Multiplier(target->Get_Defense_Object()->Get_Shield_Type(), warheadId);
				float DamageCalculated = DamageMultiplier * damage;

//				Console_Output("STOCK: damageCalculated = %f, DamageMultiplier = %f\n", 
//					DamageCalculated, DamageMultiplier); // DEBUG CRAP

				if (DamageCalculated < 30.f)
				{
					int PlayerID = Get_Player_ID(damager);

					float Credits = Get_Money(PlayerID);
					float Points = Get_Score(PlayerID);
					int Team = Get_Team(PlayerID);
					float TeamScore = Get_Team_Score(Team);

					Commands->Apply_Damage(target, damage, "Shrapnel", damager);

					Set_Money(PlayerID, Credits+1.0f);
					Set_Score(PlayerID, Points+1.0f);
					Set_Team_Score(Team, TeamScore+1.0f);

					return false;
				}
			}
//		}
	}
	return true;
}

SnipersPointsCreditsMod snipersPointsCreditsMod;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &snipersPointsCreditsMod;
}
